@extends('layouts.master')
@section('page_title', 'Select Exam Year')
@section('content')
<div class="card">
        <div class="card-header header-elements-inline">
            <h5 class="card-title"><i class="icon-alarm mr-2"></i> Select Exam Year</h5>
            {!! Qs::getPanelOptions() !!}
        </div>

        <div class="card-body">
            <div class="row">
                <div class="col-md-6 offset-md-3">
                    <form method="post" action="{{ route('marks.print.studentreports') }}">
                        @csrf
                        <div class="form-group">
                            <label for="year" class="font-weight-bold col-form-label-lg">Select Exam Year:</label>
                        
                            <select required id="year" name="year" data-placeholder="Select Exam Year" class="form-control select select-lg">
                               <option value=""></option>
                                @foreach($years as $y)
                                    <option value="{{ $y->year }}">{{ $y->year }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="year" class="font-weight-bold col-form-label-lg">Select Exam:</label>
                            <select required id="exam" name="exam_id" data-placeholder="Select Exam Year" class="form-control select select-lg">
                                
                            </select>
                        </div>

                        <input type="hidden" name="class_id" value="{{$class_id}}">
                        <input type="hidden" name="section_id" value="{{$section_id}}" >

                        <div class="text-center mt-2">
                            <button type="submit" class="btn btn-primary btn-lg">Submit <i class="icon-paperplane ml-2"></i></button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <script>
                        $(document).ready(function(){
                            // When year select changes
                            $('#year').change(function(){
                                var year = $(this).val();
                                
                                // Clear exam select
                                $('#exam').empty();
                                $('#exam').append('<option value="">Select Exam</option>');

                                // Get exams for selected year via AJAX
                                if(year) {
                                    $.ajax({
                                        url: '/api/exam/list?year=' + year,
                                        type: 'GET',
                                        success: function(data) {
                                            if(data) {
                                                // Add exam options
                                                $.each(data, function(key, exam){
                                                    $('#exam').append('<option value="'+ exam.id +'">'+ exam.name +'</option>');
                                                });
                                            }
                                        }
                                    });
                                }
                            });
                        });
                        </script>
    </div>
    @endsection
