<html>
<head>
    <title>Student Marksheet </title>
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/my_print.css') }}" />
    <style>
            body {
                font-family: Arial, sans-serif;
                background-color: #f3f4f6;
                margin: 0;
                padding: 20px;
                font-size: 1.1em !important;
            }
            .container {
                max-width: 950px;
                margin: 0 auto;
                background: #ffffff;
                padding: 10px;
            }
            .header {
                    text-align: center;
                    margin-bottom: 20px;
                }
                .header h1 {
                    font-size: 24px;
                    margin: 0;
                    text-transform: uppercase;
                }
                .header p {
                    font-size: 14px;
                    margin: 4px 0;
                }
                .section {
                    margin-bottom: 20px;
                }
                .section .info {
                    display: flex;
                    flex-wrap: wrap;
                    justify-content: space-between;
                    font-size: 14px;
                }
                .section .info div {
                    width: 48%;
                    margin-bottom: 10px;
                }
            
            .remarks {
                font-size: 14px;
                margin-top: 10px;
            }
            .remarks p {
                margin: 5px 0;
            }
            .signature-section {
                display: flex;
                justify-content: space-between;
                margin-top: 20px;
            }
            .signature-section div {
                font-size: 14px;
            }
            .footer {
                margin-top: 10px;
                font-size: 12px;
                color: #666;
            }
            .watermark {
                position: fixed;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                opacity: 0.1;
                width: 70%;
                height: auto;
                z-index: -1;
                pointer-events: none;
            }
            .print-button {
                margin: 20px 0;
                display: block;
                text-align: center;
            }
            .card-title {
                font-weight:bold;
                font-size: 1.3em;
            }
            .form-group{
                border: none;
                font-size: 1.1em;
            }
            .row{
               display: flex;
               justify-content: space-between;
               text-transform: uppercase;
            }
            .csrow{
               display: flex;
               
               text-transform: uppercase;
            }
            .comments {
              
               display: flex;
               justify-content: space-between;
               text-transform: uppercase;
               font-size: 1em;
             }

    .signatures {
      display: flex;
      justify-content: space-between;
      margin-top: 20px;
    }

    .signature-block {
      text-transform: uppercase;
      text-align: center;
    }

    .signature-block hr {
      width: 200px;
      border: none;
      border-top: 1px solid #000;
    }

    .footer {
      text-align: center;
      font-size: 12px;
      color: #888;
    }

           
            @media print {
               
                .print-button, .sample-comment   {
                    display: none;
                }
                .row{
                    width: 100% !important;
                }
                #btn-comment{
                    display:none;
                }
                @page {
                    size: A4; /* Change page size if needed */
                    margin: 10mm;
                    marks: none;
                }
                body {
                    margin: 0;
                    padding: 0;
                }

                input {
                    border: none !important;
                    outline: none !important;
                    -webkit-appearance: none !important;
                }
                
                .page-break {
                    page-break-before: always; /* Start a new page before this element */
                }
                /* Hide URL/address bar when printing */
                @page :first {
                    margin-top: 0;
                }
            }
    </style>
</head>
<body>
    <div class="print-button">
        <button type="button" onclick="printReport()">Print Now</button>
    </div>
    
@foreach($exam_records as $student)
 <?php
    
        if(request()->section_id != null){
            $data = ['my_class_id' => request()->class_id, 'section_id'=>request()->section_id];
        }else{
            $data = ['my_class_id' => request()->class_id];
        }
    
    $sectionId = $data['section_id'] ?? '';

    $temp_records = App\Models\ExamRecord::select(
        'exam_records.exam_id', 
        'exam_records.my_class_id', 
        'exam_records.student_id', 
        'u.id as student_session_id',
        'u.name as student_name',
        'u.photo',
        'exam_records.section_id', 
        'exam_records.af', 
        'exam_records.ps', 
        'exam_records.t_comment', 
        'exam_records.p_comment', 
        'exam_records.year', 
        'exam_records.total', 
        'exam_records.ave', 
        'exam_records.class_ave', 
        'exam_records.pos',
        \DB::raw("
            (
                SELECT COUNT(*) + 1 
                FROM exam_records AS er2
                WHERE er2.my_class_id = exam_records.my_class_id
                " . ($sectionId ? "AND er2.section_id = exam_records.section_id" : "") . "
                AND er2.exam_id = exam_records.exam_id
                AND er2.total > exam_records.total
            ) AS st_pos
        ")
    )->join('users as u', 'u.id', '=', 'exam_records.student_id')->when($sectionId, function ($query) use ($sectionId) {
        $query->where('exam_records.section_id', $sectionId);
    })->where($data)->orderBy('exam_records.total', 'DESC')->get();

    $exam = $temp_records->where('student_id',$student->user_id)->first();


 ?>
  <?php
           $data =  $sr->where('user_id',$student->student_id)->first();
            
        ?>
@php
    $attendance = App\Models\ExamAttendance::where('student_id',$student->student_id)->where('exam_id',$exam_id)->first();
@endphp

@php
  
$attendance_stats = App\Models\StudentAttendance::where('student_session_id', 
$student->student_id)->where('att_year', $ex->year)->where('term_id',$ex->term)->selectRaw("COUNT(*) as total, SUM(CASE WHEN attendence_type_id = '1' THEN 1 ELSE 0 END) as present")->first();

 
@endphp
<div class="container page-break">
    <div id="print" xmlns:margin-top="http://www.w3.org/1999/xhtml">
        {{--    Logo N School Details--}}
        <table width="100%"> 
            <tr>
                <td><img src="{{ $s['logo'] }}" style="max-height : 100px;"></td>

                <td style="text-align: center; ">
                    <strong><span style="color: #1b0c80; font-size: 25px;">{{ strtoupper(Qs::getSetting('system_name')) }}</span></strong><br/>
                   {{-- <strong><span style="color: #1b0c80; font-size: 20px;"></span></strong><br/>--}}
                    <strong><span style="color: #000; font-size: 15px;"><i>{{ ucwords($s['address']) }}</i></span></strong><br/>
                    <strong><span style="color: #000; font-size: 15px;"> REPORT SHEET  
                    </span></strong>
                </td>
                <td style="width: 90px; height: 100px; float: left;">
                    <img src="{{ $student->photo }}"
                         alt="..."  width="100" height="100">
                </td>
                
            </tr>
        </table>
        
        <br/>

        {{--Background Logo--}}
        <div style="position: relative;  text-align: center; ">
            <img src="{{ $s['logo'] }}"
                 style="max-width: 500px; max-height:600px; margin-top: 60px; position:absolute ; opacity: 0.1; margin-left: auto;margin-right: auto; left: 0; right: 0;" />
        </div>
      
        {{--<!-- SHEET BEGINS HERE-->--}}
        <table style="width:100%; border-collapse:collapse; ">
            <tbody>
            <tr>
                <td><strong>NAME:</strong> {{ strtoupper($student->student_name ?? '') }}</td>
                <td><strong>ADM NO:</strong> {{$data->adm_no ?? ''}} </td>
                <td><strong>CLASS:</strong> {{ strtoupper($my_class->name ?? '') }} - {{$section_name ?? ''}}</td>
                <td> @if($my_class->class_type_id != 1)<strong>POS:   </strong> {!! strtoupper(Mk::getSuffix($student->st_pos ?? '')) ?? '' !!}  @endif</td>
            </tr>
            <tr>
                <td><strong></strong> {!! strtoupper(Mk::getSuffix($ex->term)) !!}  TERM - {{$ex->name}}</td>
                <td><strong>ACADEMIC YEAR:</strong> {{ $ex->year }}</td>
                <td><strong>ATTENDANCE: 
                @if($s['auto_attendance_count'] == 0)    
                <input type="text" class="att" value="{{ $attendance->attendance ?? ''}}" style="width:70px;" onchange="saveAttendance(this.value, {{ $student->student_id }}, {{ $ex->id }}, {{ $attendance->id ?? '' }})" /></strong> 
                @else
                {{$attendance_stats->present}}/{{$attendance_stats->total}}
                @endif
                </td>
            </tr>

            </tbody>
        </table>

        <table style="width:100%; border-collapse:collapse; border: 1px solid #000; margin: 10px auto;" border="1">
    <thead>
        <tr>
            <th>SUBJECTS</th>
            <th>
                @if($ex->exam_type == 'mid-term-exam') 
                    PAPER1 
                @elseif($ex->exam_type == 'mock-exam')
                    OBJECTIVES
                @else
                    CLASS SCORE
                @endif 
                ({{ $ex->class_score }})
            </th>
            <th>
                @if($ex->exam_type == 'mid-term-exam') 
                    PAPER2
                @elseif($ex->exam_type == 'mock-exam')
                    SUBJECTIVES
                @else
                    EXAMS ({{ $ex->exam_score }})
                @endif
            </th>
            <th>FINAL MARKS</th>
            <th>GRADE</th>
            <th>SUB POSITION</th>
            <th>REMARKS</th>
        </tr>
    </thead>
    
    <tbody>
        @foreach($subjects as $sub)
            @php
                $mk = $marks->where('student_id', $student->student_id)
                            ->where('subject_id', $sub->id)
                            ->where('exam_id', $ex->id)
                            ->first();
            @endphp
            <tr>
                <td style="font-weight: bold; text-align: left; text-transform: uppercase; padding-left:10px;">
                    {{ $sub->name }}
                </td>

                <td>{{ $mk->t1 ?? '-' }}</td>
                <td>{{ $mk->exm ?? '-' }}</td>
                <td>{{ $mk->$tex ?? '-' }}</td>
                <td>{{ $mk->grade->name ?? '-' }}</td>
                <td>{!! $mk && $mk->grade ? Mk::getSuffix($mk->sub_pos) : '-' !!}</td>
                <td>{{ $mk->grade->remark ?? '-' }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="3"><strong>TOTAL SCORES OBTAINED:</strong> {{ $student->total ?? '' }}</td>
            <td colspan="2"><strong>FINAL AVERAGE:</strong> {{ $student->ave ?? '' }}</td>
            <td colspan="2"><strong>CLASS AVERAGE:</strong> {{ $student->class_ave ?? '' }}</td>
        </tr>
    </tbody>
</table>


        {{--Key to Grading--}}
    {{--@include('pages.support_team.marks.print.grading')--}}

    {{-- TRAITS - PSCHOMOTOR & AFFECTIVE --}}

       <div class="row">
        <div>
            <p><strong style="text-transform: uppercase;">KEY</strong></p>
            <table style=" border-collapse:collapse;border: 1px solid #000; text-align: left; margin: 10px 20px 0 0;" border="1">
                <tbody>
                    @foreach($grade_keys as $key)
                        <tr>
                            <td style="text-align: left; text-transform: uppercase; padding-left:10px; border: 1px solid #000;">{{$key->grade_key}}</td>
                            <td style="border: 1px solid #000;">{{$key->key_value}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div>
        <table style="border-collapse:collapse;border: 1px solid #000; text-transform: uppercase;  margin: 10px 20px; " border="1">
            
            <tr>
                <td style="text-align: left; padding-left:5px;"><strong>Score</strong></td>
                <td style="text-align: left; padding-left:5px;"><strong>Grade</strong></td>
                <td style="text-align: left; padding-left:5px;"><strong>Description</strong></td>
            </tr>
           
            <tbody>
            @foreach($grades as $grade)
                <tr>
                <td style="text-align: left; padding-left:5px;">{{$grade->mark_from}} - {{$grade->mark_to}}</td>
                <td style="text-align: left;">{{$grade->grade}}</td>
                <td style="text-align: left; padding-left:5px;">{{$grade->remark}}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
        </div>
       </div>

       <div class="csrow">
           <div>
                <table  style=" border-collapse:collapse; border: 1px solid #000; margin-top:20px; margin-right: 40px;" border="1">
                    <thead>
                    <tr>
                        <td style="text-align: left; padding-left: 10px"><strong>AFFECTIVE TRAITS</strong></td>
                        <td><strong>RATING</strong></td>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach ($skills->where('skill_type', 'AF') as $af)
                        <tr>
                            <td style="text-align: left; padding-left: 10px">{{ $af->name }}</td>
                            <td>{{ $student->af != null ? explode(',', $student->af)[$loop->index] : '' }}</td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
           </div>

           <div>
            <table style="border-collapse:collapse; border: 1px solid #000;  margin-top:20px;" border="1">
                <thead>
                <tr>
                    <td><strong>PSYCHOMOTOR</strong></td>
                    <td><strong>RATING</strong></td>
                </tr>
                </thead>
                <tbody>
                @foreach ($skills->where('skill_type', 'PS') as $ps)
                    <tr>
                        <td>{{ $ps->name }}</td>
                        <td>{{ $student->ps ? explode(',', $student->ps)[$loop->index] : '' }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table> 
           </div>
       </div>
     
        <div class="comments"> 
            <p><strong>Teacher's Comments:</strong> <span> 
                @php 
                  $exam_comments = explode(",", $s['exam_comments']);
                
                @endphp
                <br/>
                <select class="sample-comment" name="comment_select_{{ $student->student_id }}" id="comment_select_{{ $student->student_id }}" onchange="document.getElementById('t_comment_{{ $student->student_id }}').value = this.value">
                    <option value="">Select a comment</option>
                    @foreach($exam_comments as $comment)
                        <option value="{{ trim($comment) }}">{{ trim($comment) }}</option>
                    @endforeach
                </select>
                <textarea style="width: 900px !important" list="items_{{ $student->student_id }}" 
                    name="t_comment" 
                    id="t_comment_{{ $student->student_id }}"
                    onblur="saveComment(this.value, {{ $student->student_id }}, {{ $ex->id }}, 'teacher')"
                >{{ $student->t_comment }}</textarea>
                

                <datalist id="items_{{ $student->student_id }}">
                    
                </datalist>
               
            </span> 
            </p>
        </div>

        <div class="comments">
        @if($s['enable_headteacher_comment'] == 1)
            <p><strong>HEAD TEACHER'S COMMENT:</strong>
            
            <textarea style="width: 900px !important" list="items_{{ $student->student_id }}" 
                    name="p_comment" 
                    id="p_comment_{{ $student->student_id }}"
                    onblur="saveComment(this.value, {{ $student->student_id }}, {{ $ex->id }}, 'head_teacher')"
            >{{ $student->p_comment }}</textarea>
            
                <datalist id="items_{{ $student->student_id }}">
                    @foreach($exam_comments as $comment)
                        <option value="{{ trim($comment) }}">
                    @endforeach
                </datalist>
          
            
            </p>
            @endif
        </div>

        <div class="signatures">
            <div class="signature-block">
            <img src="{{ $s['sch_signature'] }}" style="max-height : 100px;"> 
            <hr>
            <div>{{(isset($s['headteacher_label']) && $s['headteacher_label'] != null) ? $s['headteacher_label'] : Headmaster}}</div>
            </div>
        </div>

</div>
@endforeach
<script>
                function saveAttendance(value, studentId, examId, attendanceId=null) {
                fetch('/api/attendance/save', {
                    method: 'POST',
                    headers: {
                    'Content-Type': 'application/json',
                    //'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                    attendance: value,
                    student_id: studentId,
                    exam_id: examId,
                    attendance_id: attendanceId
                    })
                }).then(response => response.json()).then(data => {
                    
                })
                .catch(error => {
                    console.error('Error:', error);
                    alert('Error saving attendance');
                });

                }

                function printReport(){
                    window.print()
                }

                function saveComment(value, studentId, examId, flag) {
                    fetch('/api/comments/add-comments', {method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                //'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify({
                                comment: value,
                                student_id: studentId,
                                exam_id: examId,
                                flag: flag
                            })
                        }).then(response => response.json())
                        .then(data => {
                            
                        })
                        .catch(error => {
                            console.error('Error:', error);
                            alert('Error saving comment');
                        });

                }

 </script>


</body>

</html>
